%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Abstract Class for AbSciCon2019
%
% This class file defines the structure and design of the template. 
%
% Written by: Andrew Lincowski
%             University of Washington
%
% Copying and distribution of this file, with or without modification,
% are permitted in any medium without royalty provided the copyright
% notice and this notice are preserved. This file is offered as-is,
% without any warranty.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\ProvidesClass{abstract}[]

% Base class: Article
\LoadClass[10pt,letterpaper]{article}

% Necessary common packages
\usepackage{times}                  % Times New Roman font
\usepackage[round]{natbib}          % bibliography / referencing
\usepackage{titlesec,titling}       % Title / section handling
\usepackage{multicol}               % For two-column layout
\usepackage{authblk}                % Author & affiliation handling
\usepackage{paralist}
\usepackage{hyperref}               % Links in document / bibliography / URLs
\usepackage{tabularx,graphicx}      % tables / graphics handling
\usepackage{float}                  % for forcing figures in two-column environment
\usepackage[skip=0pt]{caption}      % Reduces space between caption and figure

% Locally-included macros from AAS for journals
\usepackage{aasmacros}

% Set document margins
\usepackage[left=1.0in,top=1.0in,right=1.0in,bottom=1.0in]{geometry}

% Set URL font to same as regular text
\urlstyle{same}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%                                   FORMAT HEADER 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% reduce top of page spacing to title
\setlength{\droptitle}{-5em}

% Set Title formatting
\renewcommand{\maketitlehooka}{\footnotesize\bfseries}

% Revise author block font sizes
\renewcommand\Authfont{\normalsize\normalfont}
\renewcommand\Affilfont{\normalsize\normalfont}

% Set distance between authors and affiliation
\setlength{\affilsep}{0em}

%%% format spacing due to Date between author block and text
\predate{}
\postdate{\vspace{-3ex}}


%%% SECTION TITLES FORMATTING

% \titleformat{command}[shape]{format}{label}{sep}{before}[after]
\titleformat{\section}[runin]{\normalfont\bfseries}{\thesection}{1ex}{\indent}[:]
\titleformat{\subsection}[runin]{\normalfont\itshape}{\thesubsection}{1ex}{\indent}[.]

% \titlespacing*{<command>}{<left>}{<before-sep>}{<after-sep>}
\titlespacing{\section}{0pt}{1.0ex plus 0.5ex minus 0.5ex}{0.0ex plus 0.5ex minus 0.5ex}
\titlespacing{\subsection}{0pt}{1.0ex plus 0.5ex minus 0.5ex}{0.0ex plus 0.5ex minus 0.5ex}


%%% bibliography

% For bibtex separation natbib uses:
\setlength{\bibsep}{0pt}

%%% great way to have NO references title.

\let\OLDthebibliography\thebibliography
\renewcommand\thebibliography[1]{
  \OLDthebibliography{#1}
  \setlength{\parskip}{0pt}
  \setlength{\itemsep}{0pt plus 0.3ex}
}

\renewcommand{\bibname}{}